 ; Ŀ
 ;   Emu - make a lisp file to reconstruct a number of entities.           
 ;   Copyright 1994, 1996 by Rocket Software                               
 ;                                                                         
 ; 
 (DEFUN C:EMU (/ year aa bb cc dd ee ff gg hh ss fun fn ii wait nnn orig len
                                                            subb numm follow)
 ; Ŀ
 ;   Make variables containing header text and box characters.             
 ; 
  (setq year (substr (rtos (getvar "cdate")) 1 4))
  (setq aa "")
  (setq bb (strcat " ; " aa aa ""))
  (setq cc (strcat " ; " aa aa ""))
  (setq dd (strcat " ;   Copyright " year " by Rocket Software"
                   "                                     "))
  (setq ee (strcat " ;   This space reserved for editorial"
                   " comment.                            "))
  (setq ff " ;   ")
  (setq gg " - an entity redrawing routine written by Emu.lsp.")
  (setq hh "")
 ; Ŀ
 ;   Get entities to be drawn by child routine.                            
 ; 
  (write-line "Select entities to file: ")
  (setq ss (ssget))
 ; Ŀ
 ;   And get proposed filename.                                            
 ; 
  (setq fun (getstring "Filename (No extension): "))
  (setq fn (strcat fun ".lsp"))
 ; Ŀ
 ;   Make name string.                                                     
 ; 
  (setq ii (strcat (strcase (substr fn 1 1)) (strcase (substr fn 2) t)))
  (setq ii (strcat ff ii gg))
  (while (< (strlen ii) 76) (setq ii (strcat ii " ")))
  (setq ii (strcat ii hh))
 ; Ŀ
 ;   Ask for delay time.                                                   
 ; 
  (setq wait (getreal "Delay (seconds) <0>: "))
  (if wait (setq wait (itoa (fix (* wait 1000)))))
 ; Ŀ
 ;   Write header and Defun line.                                          
 ; 
  (if (= fn "")
      (setq fn ())
      (progn
           (setq ff (open fn "w"))
           (write-line bb ff)
           (write-line ii ff)
           (write-line dd ff)
           (write-line ee ff)
           (write-line cc ff)
           (write-line (strcat " (DEFUN C:" (strcase fun) " ()") ff) ; balance)
           (close ff)))                     ; and close it.
 ; Ŀ
 ;   Get the first entity in the ss.                                       
 ; 
  (setq nnn 0)
  (setq aa (ssname ss nnn))
  (while aa
         (setq bb aa)                             ; save entity name to bb
         (setq aa (entget aa))                    ; get entity data
         (setq orig aa)                           ; copy of aa to work from
         (setq aa ())                             ; empty aa
 ; Ŀ
 ;   Make the data list without ename or seqend ename.                     
 ; 
         (setq len 0)                             ; start at beginning of elist
         (while (setq subb (nth len orig))        ; while there is a sublist
                (setq numm (car subb))            ; get its assoc number
                (if (and (/= numm -1)             ; if not an ename
                         (/= numm 330)
                         (/= numm 5)
                         (/= numm -2))            ; and not and end ename
                    (Setq aa (cons subb aa)))     ; add assoc list to aa list
                (setq len (1+ len)))              ; next sublist
 ; Ŀ
 ;   Write entmake and data list to file.                                  
 ; 
         (if (and fn (setq ff (open fn "a")))     ; if filename & can be opened
             (progn
                  (if follow
                      (princ "  " ff)             ; indent subentities
                      (if wait
                          (write-line (strcat "  (command \"delay\" "
                                              wait ")") ff)))
                  (princ "  (entmake '" ff)       ; balance )
                  (prin1 (reverse aa) ff)         ; then write data to file
                  (write-line ")" ff)             ; balance (
                  (close ff)))                    ; and close it.
 ; Ŀ
 ;   If the edata contains an "entities follow" group then set the flag.   
 ; 
         (if (= (cdr (assoc 66 (entget bb))) 1)   ; if entities follow
                  (setq follow T))                ; set flag.
 ; Ŀ
 ;   If the current entity is a seqend then clear the flag.                
 ; 
         (if (= (cdr (assoc 0 (entget bb))) "SEQEND") ; if end of ent
             (setq follow ()))                    ; clear flag.
 ; Ŀ
 ;   See if are somewhere in a composite entity, if so then step to the    
 ;   next ename rather than going to the next member in the ss.            
 ; 
         (if follow                               ; if flag set
             (setq aa (entnext bb))               ;   get next entity
             (progn                               ; if flag not set
                  (setq nnn (1+ nnn))             ;   increment counter
                  (setq aa (ssname ss nnn)))))    ;   and get next entity.
 ; Ŀ
 ;   End file and close.                                                   
 ; 
         (if (and fn (setq ff (open fn "a")))     ; if filename & can be opened
             (progn
                  (write-line " (princ))" ff)     ; Balance (
                  (close ff)))                    ; and close it.
 (princ))